function rbf = best_result_rbf(x,y,id)
kfold = max(id);
alpha_iter =  [0.01,0.05,0.1,0.2,0.5,0.6,0.7,0.8,1,2,3,4,5,10,20,30,40,100];
acc_best = 0;
for i = 1:length(alpha_iter)
     alpha = alpha_iter(i);
     kernel_train = cell(kfold,1);
     kernel_test = cell(kfold,1);
     y_train = cell(kfold,1);
     y_test = cell(kfold,1);
     for q = 1:kfold
         id_train = find(id ~= q);
         id_test = find(id == q);
         kernel_train{q} = gramRBF(x(id_train,:),x(id_train,:),alpha);
         kernel_test{q} = gramRBF(x(id_test,:),x(id_train,:),alpha);
         y_train{q} = y(id_train);
         y_test{q} = y(id_test);
      end
     [acc_current,svmparam] = give_me_best_acc_svm(kernel_train,kernel_test,y_train,y_test);
     if acc_current > acc_best
        acc_best = acc_current
        best_alpha = alpha_iter(i);
        svmparam_best = svmparam;
      end
end
rbf.acc_kfold = acc_best;
rbf.svmparam = svmparam_best;
rbf.alpha = best_alpha;
rbf.acc_kfold = acc_best;
end

